/*
 * CarregaZones.java
 *
 * Created on 28 de mayo de 2008, 17:00
 */

package servlets;

import java.io.*;
import java.net.*;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.sql.DataSource;
import situacio.Zona;

/**
 *
 * @author dai
 * @version
 */
public class CarregaZones extends HttpServlet {
    
    /** Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     */
    Connection con = null;
    DataSource ds = null;
    ArrayList <Zona> zones = new ArrayList();
    
    protected void processRequest(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        if ( request.getSession().getAttribute("zones") == null )
        {
            try {
                        Context contextoInicial = new InitialContext(); 
                        Context contexto = (Context) contextoInicial.lookup("java:comp/env");
                        
                        ds = (DataSource) contexto.lookup( "jdbc/ConnexioImmobiliaria"); 
                        con = ds.getConnection();
                        Statement st = con.createStatement();
                        ResultSet rs = st.executeQuery("SELECT * FROM zones");
                        while ( rs.next() )
                        {
                            zones.add(new Zona(rs.getInt(1), rs.getString(2)));
                        }
                       rs.close();
                       st.close();
                       con.close();
                } 
                catch(Exception e) { 
                        // el que sigui
                }
            finally
            {
                try
                {
                    if (con != null )
                    {
                        con.close();
                    }
                }
                catch (Exception ex){}
            }

            HttpSession sessio = request.getSession();
            sessio.setAttribute("zones",zones);
            //this.getServletContext().setAttribute("zones", zones);
        }
        
        //redirigim cap a l'altra pagina
        RequestDispatcher rD = request.getRequestDispatcher("/index.jsp");
        rD.forward(request, response);
        
        out.close();
    }
    
    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {
        processRequest(request, response);
    }
    
    /** Returns a short description of the servlet.
     */
    public String getServletInfo() {
        return "Short description";
    }
    // </editor-fold>
}
